/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xml.impl.xmlbeans;

import java.io.Serializable;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xml.XMLLib;
import org.mozilla.javascript.xml.XMLObject;
import org.mozilla.javascript.xml.impl.xmlbeans.Namespace;
import org.mozilla.javascript.xml.impl.xmlbeans.QName;
import org.mozilla.javascript.xml.impl.xmlbeans.XML;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLList;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLName;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLObjectImpl;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLWithScope;

public final class XMLLibImpl
extends XMLLib
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Scriptable globalScope;
    XML xmlPrototype;
    XMLList xmlListPrototype;
    Namespace namespacePrototype;
    QName qnamePrototype;
    boolean ignoreComments;
    boolean ignoreProcessingInstructions;
    boolean ignoreWhitespace;
    boolean prettyPrinting;
    int prettyIndent;

    Scriptable globalScope() {
        return this.globalScope;
    }

    private XMLLibImpl(Scriptable globalScope) {
        this.globalScope = globalScope;
        this.defaultSettings();
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        XmlObject.class.getName();
        XMLLibImpl lib = new XMLLibImpl(scope);
        XMLLib bound = lib.bindToScope(scope);
        if (bound == lib) {
            lib.exportToScope(sealed);
        }
    }

    private void exportToScope(boolean sealed) {
        this.xmlPrototype = XML.createEmptyXML(this);
        this.xmlListPrototype = new XMLList(this);
        this.namespacePrototype = new Namespace(this, "", "");
        this.qnamePrototype = new QName(this, "", "", "");
        this.xmlPrototype.exportAsJSClass(sealed);
        this.xmlListPrototype.exportAsJSClass(sealed);
        this.namespacePrototype.exportAsJSClass(sealed);
        this.qnamePrototype.exportAsJSClass(sealed);
    }

    void defaultSettings() {
        this.ignoreComments = true;
        this.ignoreProcessingInstructions = true;
        this.ignoreWhitespace = true;
        this.prettyPrinting = true;
        this.prettyIndent = 2;
    }

    XMLName toAttributeName(Context cx, Object nameValue) {
        String localName;
        String uri;
        if (nameValue instanceof String) {
            uri = "";
            localName = (String)nameValue;
        } else {
            if (nameValue instanceof XMLName) {
                XMLName xmlName = (XMLName)nameValue;
                if (!xmlName.isAttributeName()) {
                    xmlName.setAttributeName();
                }
                return xmlName;
            }
            if (nameValue instanceof QName) {
                QName qname = (QName)nameValue;
                uri = qname.uri();
                localName = qname.localName();
            } else {
                if (nameValue instanceof Boolean || nameValue instanceof Number || nameValue == Undefined.instance || nameValue == null) {
                    throw XMLLibImpl.badXMLName(nameValue);
                }
                uri = "";
                localName = ScriptRuntime.toString(nameValue);
            }
        }
        XMLName xmlName = XMLName.formProperty(uri, localName);
        xmlName.setAttributeName();
        return xmlName;
    }

    private static RuntimeException badXMLName(Object value2) {
        String msg;
        if (value2 instanceof Number) {
            msg = "Can not construct XML name from number: ";
        } else if (value2 instanceof Boolean) {
            msg = "Can not construct XML name from boolean: ";
        } else if (value2 == Undefined.instance || value2 == null) {
            msg = "Can not construct XML name from ";
        } else {
            throw new IllegalArgumentException(value2.toString());
        }
        return ScriptRuntime.typeError(msg + ScriptRuntime.toString(value2));
    }

    XMLName toXMLName(Context cx, Object nameValue) {
        XMLName result2;
        if (nameValue instanceof XMLName) {
            result2 = (XMLName)nameValue;
        } else if (nameValue instanceof QName) {
            QName qname = (QName)nameValue;
            result2 = XMLName.formProperty(qname.uri(), qname.localName());
        } else if (nameValue instanceof String) {
            result2 = this.toXMLNameFromString(cx, (String)nameValue);
        } else {
            if (nameValue instanceof Boolean || nameValue instanceof Number || nameValue == Undefined.instance || nameValue == null) {
                throw XMLLibImpl.badXMLName(nameValue);
            }
            String name = ScriptRuntime.toString(nameValue);
            result2 = this.toXMLNameFromString(cx, name);
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    XMLName toXMLNameOrIndex(Context cx, Object value2) {
        if (value2 instanceof XMLName) {
            return (XMLName)value2;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            long test = ScriptRuntime.testUint32String(str);
            if (test < 0L) return this.toXMLNameFromString(cx, str);
            ScriptRuntime.storeUint32Result(cx, test);
            return null;
        }
        if (value2 instanceof Number) {
            double d = ((Number)value2).doubleValue();
            long l = (long)d;
            if ((double)l != d) throw XMLLibImpl.badXMLName(value2);
            if (0L > l) throw XMLLibImpl.badXMLName(value2);
            if (l > 0xFFFFFFFFL) throw XMLLibImpl.badXMLName(value2);
            ScriptRuntime.storeUint32Result(cx, l);
            return null;
        }
        if (value2 instanceof QName) {
            long test;
            QName qname = (QName)value2;
            String uri = qname.uri();
            boolean number2 = false;
            XMLName result2 = null;
            if (uri != null && uri.length() == 0 && (test = ScriptRuntime.testUint32String(uri)) >= 0L) {
                ScriptRuntime.storeUint32Result(cx, test);
                number2 = true;
            }
            if (number2) return result2;
            return XMLName.formProperty(uri, qname.localName());
        }
        if (value2 instanceof Boolean) throw XMLLibImpl.badXMLName(value2);
        if (value2 == Undefined.instance) throw XMLLibImpl.badXMLName(value2);
        if (value2 == null) {
            throw XMLLibImpl.badXMLName(value2);
        }
        String str = ScriptRuntime.toString(value2);
        long test = ScriptRuntime.testUint32String(str);
        if (test < 0L) return this.toXMLNameFromString(cx, str);
        ScriptRuntime.storeUint32Result(cx, test);
        return null;
    }

    XMLName toXMLNameFromString(Context cx, String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        int l = name.length();
        if (l != 0) {
            char firstChar = name.charAt(0);
            if (firstChar == '*') {
                if (l == 1) {
                    return XMLName.formStar();
                }
            } else if (firstChar == '@') {
                XMLName xmlName = XMLName.formProperty("", name.substring(1));
                xmlName.setAttributeName();
                return xmlName;
            }
        }
        String uri = this.getDefaultNamespaceURI(cx);
        return XMLName.formProperty(uri, name);
    }

    Namespace constructNamespace(Context cx, Object uriValue) {
        String uri;
        String prefix;
        if (uriValue instanceof Namespace) {
            Namespace ns = (Namespace)uriValue;
            prefix = ns.prefix();
            uri = ns.uri();
        } else if (uriValue instanceof QName) {
            QName qname = (QName)uriValue;
            uri = qname.uri();
            if (uri != null) {
                prefix = qname.prefix();
            } else {
                uri = qname.toString();
                prefix = null;
            }
        } else {
            uri = ScriptRuntime.toString(uriValue);
            prefix = uri.length() == 0 ? "" : null;
        }
        return new Namespace(this, prefix, uri);
    }

    Namespace castToNamespace(Context cx, Object namescapeObj) {
        if (namescapeObj instanceof Namespace) {
            return (Namespace)namescapeObj;
        }
        return this.constructNamespace(cx, namescapeObj);
    }

    Namespace constructNamespace(Context cx) {
        return new Namespace(this, "", "");
    }

    public Namespace constructNamespace(Context cx, Object prefixValue, Object uriValue) {
        String prefix;
        String uri;
        if (uriValue instanceof QName) {
            QName qname = (QName)uriValue;
            uri = qname.uri();
            if (uri == null) {
                uri = qname.toString();
            }
        } else {
            uri = ScriptRuntime.toString(uriValue);
        }
        if (uri.length() == 0) {
            if (prefixValue == Undefined.instance) {
                prefix = "";
            } else {
                prefix = ScriptRuntime.toString(prefixValue);
                if (prefix.length() != 0) {
                    throw ScriptRuntime.typeError("Illegal prefix '" + prefix + "' for 'no namespace'.");
                }
            }
        } else {
            prefix = prefixValue == Undefined.instance ? "" : (!this.isXMLName(cx, prefixValue) ? "" : ScriptRuntime.toString(prefixValue));
        }
        return new Namespace(this, prefix, uri);
    }

    String getDefaultNamespaceURI(Context cx) {
        Object ns;
        String uri = "";
        if (cx == null) {
            cx = Context.getCurrentContext();
        }
        if (cx != null && (ns = ScriptRuntime.searchDefaultNamespace(cx)) != null && ns instanceof Namespace) {
            uri = ((Namespace)ns).uri();
        }
        return uri;
    }

    Namespace getDefaultNamespace(Context cx) {
        if (cx == null && (cx = Context.getCurrentContext()) == null) {
            return this.namespacePrototype;
        }
        Object ns = ScriptRuntime.searchDefaultNamespace(cx);
        Namespace result2 = ns == null ? this.namespacePrototype : (ns instanceof Namespace ? (Namespace)ns : this.namespacePrototype);
        return result2;
    }

    QName castToQName(Context cx, Object qnameValue) {
        if (qnameValue instanceof QName) {
            return (QName)qnameValue;
        }
        return this.constructQName(cx, qnameValue);
    }

    QName constructQName(Context cx, Object nameValue) {
        QName result2;
        if (nameValue instanceof QName) {
            QName qname = (QName)nameValue;
            result2 = new QName(this, qname.uri(), qname.localName(), qname.prefix());
        } else {
            String localName = ScriptRuntime.toString(nameValue);
            result2 = this.constructQNameFromString(cx, localName);
        }
        return result2;
    }

    QName constructQNameFromString(Context cx, String localName) {
        String prefix;
        String uri;
        if (localName == null) {
            throw new IllegalArgumentException();
        }
        if ("*".equals(localName)) {
            uri = null;
            prefix = null;
        } else {
            Namespace ns = this.getDefaultNamespace(cx);
            uri = ns.uri();
            prefix = ns.prefix();
        }
        return new QName(this, uri, localName, prefix);
    }

    QName constructQName(Context cx, Object namespaceValue, Object nameValue) {
        String prefix;
        String uri;
        String localName;
        if (nameValue instanceof QName) {
            QName qname = (QName)nameValue;
            localName = qname.localName();
        } else {
            localName = ScriptRuntime.toString(nameValue);
        }
        Namespace ns = namespaceValue == Undefined.instance ? ("*".equals(localName) ? null : this.getDefaultNamespace(cx)) : (namespaceValue == null ? null : (namespaceValue instanceof Namespace ? (Namespace)namespaceValue : this.constructNamespace(cx, namespaceValue)));
        if (ns == null) {
            uri = null;
            prefix = null;
        } else {
            uri = ns.uri();
            prefix = ns.prefix();
        }
        return new QName(this, uri, localName, prefix);
    }

    Object addXMLObjects(Context cx, XMLObject obj1, XMLObject obj2) {
        XMLList listToAdd = new XMLList(this);
        if (obj1 instanceof XMLList) {
            XMLList list1 = (XMLList)obj1;
            if (list1.length() == 1) {
                listToAdd.addToList(list1.item(0));
            } else {
                listToAdd = new XMLList(this, (Object)obj1);
            }
        } else {
            listToAdd.addToList(obj1);
        }
        if (obj2 instanceof XMLList) {
            XMLList list2 = (XMLList)obj2;
            for (int i = 0; i < list2.length(); ++i) {
                listToAdd.addToList(list2.item(i));
            }
        } else if (obj2 instanceof XML) {
            listToAdd.addToList(obj2);
        }
        return listToAdd;
    }

    public boolean isXMLName(Context cx, Object nameObj) {
        String name;
        try {
            name = ScriptRuntime.toString(nameObj);
        }
        catch (EcmaError ee) {
            if ("TypeError".equals(ee.getName())) {
                return false;
            }
            throw ee;
        }
        int length = name.length();
        if (length != 0 && XMLLibImpl.isNCNameStartChar(name.charAt(0))) {
            for (int i = 1; i != length; ++i) {
                if (XMLLibImpl.isNCNameChar(name.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isNCNameStartChar(int c) {
        if ((c & 0xFFFFFF80) == 0) {
            if (c >= 97) {
                return c <= 122;
            }
            if (c >= 65) {
                if (c <= 90) {
                    return true;
                }
                return c == 95;
            }
        } else if ((c & 0xFFFFE000) == 0) {
            return 192 <= c && c <= 214 || 216 <= c && c <= 246 || 248 <= c && c <= 767 || 880 <= c && c <= 893 || 895 <= c;
        }
        return 8204 <= c && c <= 8205 || 8304 <= c && c <= 8591 || 11264 <= c && c <= 12271 || 12289 <= c && c <= 55295 || 63744 <= c && c <= 64975 || 65008 <= c && c <= 65533 || 65536 <= c && c <= 983039;
    }

    private static boolean isNCNameChar(int c) {
        if ((c & 0xFFFFFF80) == 0) {
            if (c >= 97) {
                return c <= 122;
            }
            if (c >= 65) {
                if (c <= 90) {
                    return true;
                }
                return c == 95;
            }
            if (c >= 48) {
                return c <= 57;
            }
            return c == 45 || c == 46;
        }
        if ((c & 0xFFFFE000) == 0) {
            return XMLLibImpl.isNCNameStartChar(c) || c == 183 || 768 <= c && c <= 879;
        }
        return XMLLibImpl.isNCNameStartChar(c) || 8255 <= c && c <= 8256;
    }

    XMLName toQualifiedName(Context cx, Object namespaceValue, Object nameValue) {
        String localName;
        if (nameValue instanceof QName) {
            QName qname = (QName)nameValue;
            localName = qname.localName();
        } else {
            localName = ScriptRuntime.toString(nameValue);
        }
        Namespace ns = namespaceValue == Undefined.instance ? ("*".equals(localName) ? null : this.getDefaultNamespace(cx)) : (namespaceValue == null ? null : (namespaceValue instanceof Namespace ? (Namespace)namespaceValue : this.constructNamespace(cx, namespaceValue)));
        String uri = ns == null ? null : ns.uri();
        return XMLName.formProperty(uri, localName);
    }

    public Ref nameRef(Context cx, Object name, Scriptable scope, int memberTypeFlags) {
        if ((memberTypeFlags & 2) == 0) {
            throw Kit.codeBug();
        }
        XMLName xmlName = this.toAttributeName(cx, name);
        return this.xmlPrimaryReference(cx, xmlName, scope);
    }

    public Ref nameRef(Context cx, Object namespace, Object name, Scriptable scope, int memberTypeFlags) {
        XMLName xmlName = this.toQualifiedName(cx, namespace, name);
        if ((memberTypeFlags & 2) != 0 && !xmlName.isAttributeName()) {
            xmlName.setAttributeName();
        }
        return this.xmlPrimaryReference(cx, xmlName, scope);
    }

    private Ref xmlPrimaryReference(Context cx, XMLName xmlName, Scriptable scope) {
        XMLObjectImpl xmlObj;
        block2: {
            XMLObjectImpl firstXmlObject = null;
            do {
                if (!(scope instanceof XMLWithScope)) continue;
                xmlObj = (XMLObjectImpl)scope.getPrototype();
                if (xmlObj.hasXMLProperty(xmlName)) break block2;
                if (firstXmlObject != null) continue;
                firstXmlObject = xmlObj;
            } while ((scope = scope.getParentScope()) != null);
            xmlObj = firstXmlObject;
        }
        if (xmlObj != null) {
            xmlName.initXMLObject(xmlObj);
        }
        return xmlName;
    }

    public String escapeAttributeValue(Object value2) {
        String text2 = ScriptRuntime.toString(value2);
        if (text2.length() == 0) {
            return "";
        }
        XmlObject xo = XmlObject.Factory.newInstance();
        XmlCursor cursor = xo.newCursor();
        cursor.toNextToken();
        cursor.beginElement("a");
        cursor.insertAttributeWithValue("a", text2);
        cursor.dispose();
        String elementText = xo.toString();
        int begin = elementText.indexOf(34);
        int end = elementText.lastIndexOf(34);
        return elementText.substring(begin + 1, end);
    }

    public String escapeTextValue(Object value2) {
        if (value2 instanceof XMLObjectImpl) {
            return ((XMLObjectImpl)value2).toXMLString(0);
        }
        String text2 = ScriptRuntime.toString(value2);
        if (text2.length() == 0) {
            return text2;
        }
        XmlObject xo = XmlObject.Factory.newInstance();
        XmlCursor cursor = xo.newCursor();
        cursor.toNextToken();
        cursor.beginElement("a");
        cursor.insertChars(text2);
        cursor.dispose();
        String elementText = xo.toString();
        int begin = elementText.indexOf(62) + 1;
        int end = elementText.lastIndexOf(60);
        return begin < end ? elementText.substring(begin, end) : "";
    }

    public Object toDefaultXmlNamespace(Context cx, Object uriValue) {
        return this.constructNamespace(cx, uriValue);
    }
}

